#include "Mesquite_all_headers.hpp"
#include <iostream>
#include <sstream>

#include "CompositeOFExponent.hpp"
#include "CompositeOFNLog.hpp"

#include "jibum_untangle.cpp"

using std::cout;
using std::cerr;
using std::endl;
using std::ostream;
using std::ostringstream;

#include <memory>
using std::auto_ptr;

#include <ctype.h>

using namespace MESQUITE_NS;


void deformBoundary( MeshImpl& deformedMesh, MeshImpl& origMesh, double a)
{
  MsqPrintError err(cerr);

  std::vector<Mesh::VertexHandle> vertices;
  origMesh.get_all_vertices(vertices, err);
  if (MSQ_CHKERR(err)) {std::cout << err << std::endl; exit(EXIT_FAILURE);}
  size_t num_vertices = vertices.size();
  
  cout<<"num vertices="<<num_vertices<<endl;
  // get vertex coordinates
  std::vector<MsqVertex> coordinates(num_vertices);
  origMesh.vertices_get_coordinates( arrptr(vertices), arrptr(coordinates), num_vertices, err);
  if (MSQ_CHKERR(err)) {std::cout << err << std::endl; exit(EXIT_FAILURE);}
  
  // get application fixed vertices
  std::vector<bool> app_fixed(num_vertices);
  origMesh.vertices_get_fixed_flag( arrptr(vertices), app_fixed, num_vertices, err );

  if (MSQ_CHKERR(err)) {std::cout << err << std::endl; exit(EXIT_FAILURE);}
  
  cout<<"num fixed vertices="<<app_fixed.size()<<endl;

 // double twopi=8.0*atan(1.0);

  for(size_t i=0;i<num_vertices; i++)
  {
    if( app_fixed[i] == true )
    {
      double x = coordinates[i].x();
    //  double y = 1.25*coordinates[i].y();
      double y = coordinates[i].y();
     // double z = coordinates[i].x()*coordinates[i].z();
 double z = coordinates[i].z();

   //   if( ( (1-(x*x/4.0 + y*y/16.0))<.00001 ) && (y>.01) )
   //   {
	//
	// set new boundary vertices for deformed mesh
	//
	Vector3D newPos(x,y,z);
	deformedMesh.vertex_set_coordinates(vertices[i], newPos, err);
	if (MSQ_CHKERR(err)) {std::cout << err << std::endl; exit(EXIT_FAILURE);}

     // }
    }
  }//end of loop over vertices

  deformedMesh.write_vtk("DeformedMesh.vtk", err);
  if (MSQ_CHKERR(err)) {std::cout << err << std::endl; exit(EXIT_FAILURE);}

  cout<<"Leaving deformBoundary."<<endl;
}//end of deformBoundary




int do_smoother( const char* input_file, const char* input_file_1, const char* output_file, int a)
{
  MsqPrintError err(cerr);
   
  //
  // Mesh we will be optimizing
  //
  MeshImpl mesh, deformedMesh;
  mesh.read_vtk( input_file, err );
  deformedMesh.read_vtk( input_file_1, err);

  mesh.write_vtk( "InitialMesh.vtk", err );
  deformedMesh.write_vtk( "DeformedMesh.vtk", err);




  if (MSQ_CHKERR(err)) return 2;

//  MeshImpl deformedMesh;
//  deformedMesh.read_vtk( input_file, err );

// deformBoundary(deformedMesh, mesh, 2);
  //
  // constrain it to be planar.
  //


//////////////////////////////////
//  TShapeSize2DNB1 target_metric;
 TShapeNB1 target_metric; 
   TSizeNB1 target_metric_1;
//TShapeSize2DNB1 target_metric_1;
//   TUntangleBeta target_metric(0.1);
//////////////////////////////////


 // IdealShapeTarget W;

  ReferenceMesh refMesh( &mesh );
  RefMeshTargetCalculator W( &refMesh, false );

TQualityMetric mu( &W, &target_metric );
 TQualityMetric nu( &W, &target_metric_1 );
//  TQualityMetric nu(&W, &target_metric_1);
  //   TUntangleMu target_metric_2(&target_metric_1,0);

 // TQualityMetric lu(&W, &target_metric_2); 



// jibum_untangle nu(0.0001);

  //IdealWeightInverseMeanRatio inverse_mean_ratio(err);
//	jibum_size_metric int_si_qm;
//	jibum_int_si si_qm;
	//IdealWeightInverseMeanRatio inverse_mean_ratio(err);

//	// creat a template
//	PMeanPTemplate  objective_function( 2.0, &mu);
	PMeanPTemplate  obj_func1( 2.0, &mu);
        PMeanPTemplate  obj_func2( 2.0, &nu);
//	LPtoPTemplate  obj_func2(&nu, 2, err);
	double c = 1e+6;

//CompositeOFAdd objective_function(&obj_func1, &obj_func2, 0);
  
//  PMeanPTemplate objective_function( 2.0, &lu);


	CompositeOFScalarMultiply obj_func11(1.0/c,&obj_func1,0);
	CompositeOFScalarMultiply obj_func21(1.0/c,&obj_func2,0);
	CompositeOFExponent obj_func12(&obj_func11,0);
	CompositeOFExponent obj_func22(&obj_func21,0);
	CompositeOFAdd obj_func3(&obj_func1, &obj_func2, 0);
	CompositeOFNLog obj_func31(&obj_func3, 0);
	CompositeOFScalarMultiply objective_function(c,&obj_func31,0);



  TerminationCriterion outer, inner;
  
//  FeasibleNewton solver( &objective_function );
   ConjugateGradient solver( &objective_function);

  if (MSQ_CHKERR(err)) return 1;

  solver.set_inner_termination_criterion( &inner );
  solver.set_outer_termination_criterion( &outer );
  
  bool isSolverGlobal = false;
 // bool isSolverGlobal = false;
  if( isSolverGlobal )
  {
    solver.use_global_patch();

    outer.add_iteration_limit( 1 );
    //       outer.add_relative_successive_improvement(1e-5);

    //       inner.add_absolute_vertex_movement(1e-5);
    inner.add_relative_successive_improvement(1e-7);
    // inner.write_mesh_steps("mesh_");
    //       inner.add_relative_element_overlap(0.5);

  }
  else  // local solver
  {
    solver.use_element_on_vertex_patch();

// outer.add_relative_quality_improvement(1e-3);
 
 outer.add_iteration_limit( a );
 inner.add_iteration_limit( 1 );
  //  outer.add_relative_successive_improvement(1e-8);
   //        outer.add_iteration_limit( 1 );
    // outer.write_mesh_steps("mesh_");

    //   inner.add_absolute_vertex_movement(1e-5);
   // inner.add_relative_successive_improvement(1e-5);
    // inner.add_iteration_limit( 2 );
  }
  
  
  jibum_untangle qm_metric;
  QualityAssessor assessor;
  assessor.add_quality_assessment( &mu, 10 );
  assessor.add_quality_assessment( &qm_metric );

  InstructionQueue q;
  q.add_quality_assessor( &assessor, err );
  q.set_master_quality_improver( &solver, err );
  q.add_quality_assessor( &assessor, err );

#if 0
  Settings theSettings;
  theSettings.set_slaved_ho_node_mode(Settings::SLAVE_NONE);
	
  q.run_common( &deformedMesh, NULL, &geom, &theSettings, err );
#else
  q.run_instructions( &deformedMesh,  err);
#endif
  if (MSQ_CHKERR(err)) return 3;

 deformedMesh.write_vtk( output_file, err );
  if (MSQ_CHKERR(err)) return 2;
  cout << "Wrote: " << output_file << endl;
  cout<<" Convergence in "<<outer.get_iteration_count()<<" outer iterations."<<endl;
  cout<<" Convergence in "<<inner.get_iteration_count()<<" inner iterations."<<endl;

  cout<<"Leaving do_smoother."<<endl;
  return 0;
}

int main( int argc, char* argv[] )
{
  MsqPrintError err(cout);
    
  ostringstream meshfile,meshfile_1, outfile;
 // double a=1.1;

 // if( argc > 1 )
 // {
 //   a = atof(argv[1]);
 // }
    
  int aaa = atof(argv[1]);
 // meshfile <<"/g/g92/kim74/mesquite-2.99/mesquite-debug/DeformingMeshes/hook.vtk";
 //  meshfile <<"/g/g92/kim74/mesquite-2.99/mesquite-debug/DeformingMeshes/foam5.vtk"; 

// meshfile <<"/g/g92/kim74/crown_initial.vtk"; 
// meshfile_1 << "/g/g92/kim74/crown_deformed.vtk";

 meshfile <<"/g/g92/kim74/hook.vtk"; 
 meshfile_1 << "/g/g92/kim74/out_3d_1.vtk";

  outfile<<"/g/g92/kim74/SmoothedMesh.vtk";
 // int result = do_smoother( meshfile.str().c_str(), outfile.str().c_str(), a);
 int result = do_smoother( meshfile.str().c_str(), meshfile_1.str().c_str(), outfile.str().c_str(), aaa);
  cout<<" main finished."<<endl;

  return result;
}

